﻿/*
VERSION: 1.1
1.1		Added "change" event

USAGE:
	#include "functions/tank_turn.as"
	player_mc.turn_obj = makeTankTurn( player_mc );											// this handles rotation of the "radian"
	#include "functions/strafe.as"
	player_mc.strafe_obj = makeStrafe( player_mc, player_mc.sprite );		// this moves the player
	
	player_mc.turn_obj.resetVelocity();		// set velocity to Zero			(useful when switching between movement systems in real-time)
	player_mc.strafe_obj.resetVelocity();		// set velocity to Zero		(useful when switching between movement systems in real-time)
	
	// tank_turn will emit "change_radian" events within player_mc
	// tank_move will detect those events within player_mc and update its own radian
	
	onUnload = function(){
		clearInterval(turn_obj.loopInterval);
		clearInterval(strafe_obj.loopInterval);
	}
	
	
SETTINGS:
	key_moveForward		Key code for moving forward
	key_moveBackward	Key code for moving backward
	key_moveLeft			Key code for strafing left
	key_moveRight			Key code for strafing right
	
	xVel					previously applied horizontal speed		(in pixels per frame)
	yVel					previously applied vertical speed			(in pixels per frame)
	
	
PROPERTIES:
	maxSpeed			Maximum speed  (in pixels per frame)
	acel					Acelleration speed,  how many pixels the velocity increases per frame while a key is pressed
	decel					Deceleration speed, multiplier that reduces velocity per frame when no key is pressed
	walkSpeed			Maximum speed  (in pixels per frame)
	
	
	
RAM.keys defaults
	RAM.keys.up
	RAM.keys.down
	RAM.keys.left
	RAM.keys.right
	
	
EVENTS:
	unload
	change				{value: Point}		(local-relative movement.  -y forward  +y backward  -x left  +x right)
	change_radian
	
PLAYER EVENTS:
	request_radian
	
RESPONDS TO PLAYER EVENTS:
	change_radian
	unload
	
	
NOTES:
	This system has optional hooks for these collision and sprite systems:
		sprite.as
		WalkCollision.as
	It will use them if they're present.
	
	This system relies on a "radian" variable,  but cannot alter it by itself.
		This variable can be manually altered by changing the value of  strafe_obj.radian
		or it can be automatically updated via  "change_radian"  events firing within player_mc or strafe_obj
	
	
ADDING COLLISION:
	A collision system can be added like this:
		strafe_obj.collision = new Collision( player_mc, strafe_obj, collision_array, -8, -8 );
	The strafe_obj is this movement system.
*/
function makeStrafe( player_mc, playerSprite_mc ){
	var Point = flash.geom.Point;
	#include "eventSystem3.as"
	var _this = {};		// external interface
	AsBroadcaster.initialize( _this );
	var react = make_react( _this );		// param is optional
	react.to("unload").from( player_mc ).tell( _this );
	react.to("change_radian").from( player_mc ).tell( _this );
	
	
	
	// Variables
	var fps = 30;
	// movement speed
	_this.move_acel = 1;				// acelleration increment
	_this.move_decel = 0.6;			// brake multiplier
	_this.localSpeed_p = new Point( 0,0 );				// current movement speed		(un-rotated local-relative vector)
	_this.move_maxSpeed = 10;
	// cartesian velocities for:   external collision systems  =>  final movement
	_this.xVel = 0;
	_this.yVel = 0;
	// controls
	_this.key_moveForward = RAM.keys.up || Key.UP;
	_this.key_moveBackward = RAM.keys.down || Key.DOWN;
	_this.key_moveLeft = RAM.keys.left || Key.LEFT;
	_this.key_moveRight = RAM.keys.right || Key.RIGHT;
	// allow the player's image-sprite to be swapped-out later
	_this.playerSprite_mc = playerSprite_mc;
	// rotation
	_this.radian = Math.PI /180 *90;		// current rotation  (in radians)
	// initially request a radian from player_mc,  and store the result
	sendEvent( "request_radian", {callback: function( newValue ){
		_this.radian = newValue;
	}}, player_mc );
	// update whenever external code changes the radian
	react.to("change_radian").then = function( evt ){
		_this.radian = evt.value;
	}
	/*	
	react.to("change_radian").from( player_mc ).then = function( evt ){
		_this.radian = evt.value;
	}
	*/
	
	
	// legacy
	// // move speed
	_this.addProperty( "maxSpeed", function(){
		return _this.move_maxSpeed;
	}, function( newValue ){
		_this.move_maxSpeed = newValue;
	});
	_this.addProperty( "walkSpeed", function(){
		return _this.move_maxSpeed;
	}, function( newValue ){
		_this.move_maxSpeed = newValue;
	});
	_this.addProperty( "acel", function(){
		return _this.move_acel
	}, function( newValue ){
		_this.move_acel = newValue;
	});
	_this.addProperty( "decel", function(){
		return _this.move_decel
	}, function( newValue ){
		_this.move_decel = newValue;
	});
	// // controls
	_this.addProperty( "up_key", function(){
		return _this.key_moveForward
	}, function( newValue ){
		_this.key_moveForward = newValue;
	});
	_this.addProperty( "down_key", function(){
		return _this.key_moveBackward
	}, function( newValue ){
		_this.key_moveBackward = newValue;
	});
	_this.addProperty( "left_key", function(){
		return _this.key_moveLeft
	}, function( newValue ){
		_this.key_moveLeft = newValue;
	});
	_this.addProperty( "right_key", function(){
		return _this.key_moveRight
	}, function( newValue ){
		_this.key_moveRight = newValue;
	});
	
	
	
	// provide a useful utility function
	_this.rotatePoint = rotatePoint;
	
	
	
	_this.resetVelocity = function(){
		_this.localSpeed_p.x =_this.localSpeed_p.y = 0;
	}// resetVelocity()
	
	
	
	
	
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
	// Main Program
	_this.loop = function(){
		//  Abort if the player sprite doesn't exist
		if(player_mc._currentframe === undefined){
			sendEvent("unload");
			return;
		}// if:   player_mc is missing
		
		// update total speeds
		_this.localSpeed_p = changeMoveVelocity( _this.localSpeed_p );		// pixel movement magnitude
 		_this.localSpeed_p.x = limitMoveSpeed( _this.localSpeed_p.x );
		_this.localSpeed_p.y = limitMoveSpeed( _this.localSpeed_p.y );
		var local_p = _this.localSpeed_p;
		
		// get cartesian velocities
		var global_p = rotatePoint( local_p, _this.radian );
		_this.xVel = global_p.x;
		_this.yVel = global_p.y;
		
		_this.collision.run();		// apply external collision  (zeros xVel/yVel when collisions occur)
		setAnimSpeed( _this.xVel, _this.yVel );
		applyMovement( _this.xVel, _this.yVel );
		
		if( lastMoveSpeed !== _this.localSpeed_p )		sendEvent( "change", {value: _this.localSpeed_p});
		lastMoveSpeed = _this.localSpeed_p;
	}// loop()
	_this.loopInterval = setInterval( function(){
		_this.loop();
	}, 1000/fps );
	react.to("unload").then = function(){
		clearInterval(_this.loopInterval);
	}
	
	return _this;
	
	
	
	
	
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
	function limitMoveSpeed( move_speed ){
		if( move_speed > _this.move_maxSpeed )		move_speed = _this.move_maxSpeed;
		if( move_speed < -_this.move_maxSpeed )		move_speed = -_this.move_maxSpeed;
		return move_speed;
	}// limitMoveSpeed()
	
	
	
	function applyMovement( x, y ){
		player_mc._x += x;
		player_mc._y += y;
	}// applyMovement()
	
	
	
	function setAnimSpeed( xVel, yVel ){
		var xVel = Math.abs(xVel);
		var yVel = Math.abs(yVel);
		// adjust walk speed
		var max = 5;
		var range = 4;
		var topSpeed = 10;		// used for animation
		//var moveSpeed = Math.sqrt(_this.xVel*_this.xVel + _this.yVel*_this.yVel);
		var moveSpeed =  (xVel > yVel)  ?  xVel  :  yVel;		// Use the fastest velocity
		var speedPercent = Math.abs(moveSpeed) / topSpeed;		// get percent
		var animSpeed = max - (range * speedPercent);
		var animSpeed = (animSpeed<1) ? 1 : animSpeed;		// enforce max speed
		_this.playerSprite_mc.setParams({delay:animSpeed});
	}// setAnimSpeed()
	
	
	
	function changeMoveVelocity( speed_p ){
		var xSpeed = speed_p.x;
		var ySpeed = speed_p.y;
		
		
		// horz
		if( _this.key_moveLeft  &&  Key.isDown( _this.key_moveLeft ) ){
			if( xSpeed < _this.move_maxSpeed ){
				if(xSpeed < 0)		decellerateHorz();
				xSpeed += _this.move_acel;
			}// if:   not at or beyond the max speed
		}else if( _this.key_moveRight  &&  Key.isDown( _this.key_moveRight ) ){
			if( xSpeed > -_this.move_maxSpeed ){
				if(turn_vel > 0)		decellerateHorz();
				xSpeed -= _this.move_acel;
			}// if:   not at or beyond the max speed
		}else{
			decellerateHorz();
		}
		function decellerateHorz(){
			xSpeed *= _this.move_decel;
			if( Math.abs( xSpeed ) < 1 )		xSpeed = 0;		// if less than 1 pixel of movement,  then => no movement
		}// decellerateHorz()
		if( xSpeed > _this.move_maxSpeed )		xSpeed = _this.move_maxSpeed;
		if( xSpeed < -_this.move_maxSpeed )		xSpeed = -_this.move_maxSpeed;
		
		
		// vert
		if( _this.key_moveForward  &&  Key.isDown( _this.key_moveForward ) ){
			if( ySpeed < _this.move_maxSpeed ){
				if(ySpeed < 0)		decellerateVert();
				ySpeed += _this.move_acel;
			}// if:   not at or beyond the max speed
		}else if( _this.key_moveBackward  &&  Key.isDown( _this.key_moveBackward ) ){
			if( ySpeed > -_this.move_maxSpeed ){
				if(turn_vel > 0)		decellerateVert();
				ySpeed -= _this.move_acel;
			}// if:   not at or beyond the max speed
		}else{
			decellerateVert();
		}
		function decellerateVert(){
			ySpeed *= _this.move_decel;
			if( Math.abs( ySpeed ) < 1 )		ySpeed = 0;		// if less than 1 pixel of movement,  then => no movement
		}// decellerateMove()
		if( ySpeed > _this.move_maxSpeed )		ySpeed = _this.move_maxSpeed;
		if( ySpeed < -_this.move_maxSpeed )		ySpeed = -_this.move_maxSpeed;
		
		var Point = flash.geom.Point;
		return new Point( xSpeed, ySpeed );
	}// changeMoveVelocity()
	
	
	
	function rotatePoint( input_p, apply_clockwise_radian ){
		var Matrix = flash.geom.Matrix;
		var Point = flash.geom.Point;
		
		// Matrix technique
		// var rotateLeft_rad = -90 * Math.PI / 180;		// -1.5707963267949
		var rotateLeft_rad = -1.5707963267949;
		apply_clockwise_radian += rotateLeft_rad;
		var work_mat = new Matrix( 1,0,0,1, -input_p.x, -input_p.y );
		work_mat.rotate( apply_clockwise_radian);
		var output = new Point( work_mat.tx, work_mat.ty );
		return output;
	}// rotatePoint()
	
}// makeStrafe()